<?php

function sm_register_shortcode_handler_sm_tab() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		require_once vc_path_dir( 'SHORTCODES_DIR', 'vc-column.php' );
		require_once vc_path_dir( 'SHORTCODES_DIR', 'vc-tab.php' );
		class WPBakeryShortCode_sm_tab extends WPBakeryShortCode_VC_Tab {
			function content($atts, $content = null) {
				return sm_tab_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_tab', 'sm_tab_func' );
	}
}

function sm_tab_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'tab', $view_params );
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Tab', 'semona-extension' ),
	'base' => 'sm_tab',
	'allowed_container_element' => 'vc_row',
	'is_container' => true,
	'content_element' => false,
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-tab.png',
	'params' => array_merge(
		array(
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Title', 'semona-extension' ),
				'param_name' => 'title',
				'description' => esc_html__( 'Enter title of tab.', 'semona-extension' )
			),
			array(
				'type' => 'tab_id',
				'heading' => esc_html__( 'Tab ID', 'semona-extension' ),
				'param_name' => 'tab_id'
			)
		),
		sm_get_icon_options_array( '', true )
	),
	'js_view' => 'SMTabView'
) );
